%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Name: k-means clustering image segmentation algorithm
%---------------------------------------------------------------------------------------------------------------------------------------------------------------
% Author: Amit Narahar Pujari, Email contact: amitnpujari@gmail.com
%---------------------------------------------------------------------------------------------------------------------------------------------------------------
% Run time: Takes approximately 2/3 minutes to completely execute and display the final results (depending on system configuration)
%---------------------------------------------------------------------------------------------------------------------------------------------------------------
% Software version: Written in MATLAB 6.5 environment
%---------------------------------------------------------------------------------------------------------------------------------------------------------------
% Input parameters:
% ima: gray level image
% k: Number of classes(clusters)
%---------------------------------------------------------------------------------------------------------------------------------------------------------------
% Output parameters:
% mu: vector of cluster means 
% mask: clustered image 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [mu,mask]=kmeans(ima,k)

%--------------------------------------------------------------------------------------------------------------------------------------------------------------


% check image
clear;
newimag = imread('hd03.jpg');                % Loads image to be clustered
newimag = rgb2gray(newimag);                 % Converts RGB colour images in greyscale(for calculations)
newimag = double(newimag);     
ima=newimag;
mi=min(min(ima));                            % deal with negative 
ima=ima-mi+1;                                % and zero values
m=max(max(ima))+1;
s = size(ima);
% initiate centroids-----------------------------------------------------------------------------------------------------------------------------------------
k=4;                   
mu=(1:k)*m/(k+1);
hc(1:4) = 0;
sumc(1:4) = 0;
% start process---------------------------------------------------------------------------------------------------------------------------------------------
counter = 1;                                 % to prevent inifinite iteration
while(true)
    
    oldmu=mu;                                % current centroids
    
    %classify points to current centroids and calculate new centroids-------------------------------------------------------------------------------------
    hc(1:4) = 0;                             % initialize contains count of point allocated to each centroid
    sumc(1:4) = 0;                           %initialize contains sum of points allocated to each centroid 
    for i=1:s(1)
        for j = 1:s(2)
            c=abs(ima(i,j)-mu);
            cc=find(c==min(c));
            sumc(cc(1)) = sumc(cc(1)) + ima(i,j);               %contains sum of points allocated to each centroid 
            hc(cc(1))=hc(cc(1)) + 1;                            %contains count of point allocated to each centroid
        end
    end
    mu  = sumc./hc;                                             % calculate new centroids
    if(mu==oldmu) break;end; 
    if (counter > 100) break;end;                               % to prevent inifinite iteration
    counter = counter  +1 ;                                     % to prevent inifinite iteration
end

% calculate
% mask----------------------------------------------------------------------------------------------------------------------------------------------------
mask = zeros([k s(1) s(2)]);
for i=1:s(1)
    for j=1:s(2)
        c=abs(ima(i,j)-mu);
        cc=find(c==min(c));  
        mask(cc(1),i,j)=1;
    end
end


imshow(squeeze(mask(1,:,:)))                                    % displays final image for cluster 1  
figure
imshow(squeeze(mask(2,:,:)))                                    % displays final image for cluster 2 
figure
imshow(squeeze(mask(3,:,:)))                                    % displays final image for cluster 3
figure
imshow(squeeze(mask(4,:,:)))                                    % displays final image for cluster 4
